/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;

public interface ISlotTracker {
    public Set<ItemStackKey> getFullStacks();

    public Set<ItemStackKey> getPartialStacks();

    public void removeAndSetSlotIndexes(InventoryHandler var1, int var2, ItemStack var3);

    public void clear();

    public void refreshSlotIndexesFrom(InventoryHandler var1);

    public ItemStack insertItemIntoHandler(InventoryHandler var1, IItemHandlerInserter var2, UnaryOperator<ItemStack> var3, ItemStack var4, boolean var5);

    public ItemStack insertItemIntoHandler(InventoryHandler var1, IItemHandlerInserter var2, UnaryOperator<ItemStack> var3, int var4, ItemStack var5, boolean var6);

    public void registerListeners(Consumer<ItemStackKey> var1, Consumer<ItemStackKey> var2, Runnable var3, Runnable var4);

    public void unregisterStackKeyListeners();

    public boolean hasEmptySlots();

    public static class Noop
    implements ISlotTracker {
        @Override
        public Set<ItemStackKey> getFullStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<ItemStackKey> getPartialStacks() {
            return Collections.emptySet();
        }

        @Override
        public void removeAndSetSlotIndexes(InventoryHandler inventoryHandler, int slot, ItemStack stack) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void refreshSlotIndexesFrom(InventoryHandler itemHandler) {
        }

        @Override
        public ItemStack insertItemIntoHandler(InventoryHandler itemHandler, IItemHandlerInserter inserter, UnaryOperator<ItemStack> overflowHandler, ItemStack stack, boolean simulate) {
            return stack;
        }

        @Override
        public ItemStack insertItemIntoHandler(InventoryHandler itemHandler, IItemHandlerInserter inserter, UnaryOperator<ItemStack> overflowHandler, int slot, ItemStack stack, boolean simulate) {
            return inserter.insertItem(slot, stack, simulate);
        }

        @Override
        public void registerListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        }

        @Override
        public void unregisterStackKeyListeners() {
        }

        @Override
        public boolean hasEmptySlots() {
            return false;
        }
    }

    public static interface IItemHandlerInserter {
        public ItemStack insertItem(int var1, ItemStack var2, boolean var3);
    }
}

